//
//  Animating_and_Scaling_ViewsViewController.m
//  Animating and Scaling Views
//
//  Created by Vandad Nahavandipoor on 17/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Animating_and_Scaling_ViewsViewController.h"

@implementation Animating_and_Scaling_ViewsViewController

@synthesize xcodeImageView;

- (void)didReceiveMemoryWarning
{
  [super didReceiveMemoryWarning];
  // Usunięcie wszelkich buforowanych danych, obrazów itd., które nie są obecnie używane.
}

#pragma mark - Cykl życiowy widoku

- (void) viewDidLoad{
  [super viewDidLoad];
  
  UIImage *xcodeImage = [UIImage imageNamed:@"Xcode.png"];
  
  self.xcodeImageView = [[UIImageView alloc]
                         initWithImage:xcodeImage];
  
  /* Ustawiamy mniejsze wymiary obrazu. */
  [self.xcodeImageView setFrame:CGRectMake(0.0f,
                                           0.0f,
                                           100.0f,
                                           100.0f)];
  
  self.view.backgroundColor = [UIColor whiteColor];
  [self.view addSubview:self.xcodeImageView];
  
}

- (void)viewDidUnload{
  [super viewDidUnload];
  self.xcodeImageView = nil;
}

- (void) viewDidAppear:(BOOL)paramAnimated{
  [super viewDidAppear:paramAnimated];
  
  /* Umieszczenie widoku obrazu na środku widoku kontrolera widoku. */
  self.xcodeImageView.center = self.view.center;
  
  /* Upewniamy się, że żadne przekształcenie nie jest stosowane względem tego widoku obrazu. */
  self.xcodeImageView.transform = CGAffineTransformIdentity;
  
  /* Rozpoczęcie animacji. */
  [UIView beginAnimations:nil
                  context:NULL];
  
  /* Animacja trwa pięć sekund. */
  [UIView setAnimationDuration:5.0f];
  
  /* Dwukrotne zwiększenie szerokości i wysokości widoku obrazu. */
  self.xcodeImageView.transform = CGAffineTransformMakeScale(2.0f,
                                                             2.0f);
  
  /* Zatwierdzenie animacji. */
  [UIView commitAnimations];
  
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
